using System;

namespace ScoreBoard
{
	/// <summary>
	/// FUNCTIONAL UNIT CLASS : INDICATES THE STATE OF THE FUNCTIONAL UNIT (FU)
	///							THERE ARE 9 FIELDS OF EACH FU
	/// </summary>
	public class FU
	{
		public string Name;						// NAME OF THE FU
		public bool Busy ;						// INDICATES WHETHER THE UNTI IS BUSY OR NOT
		public string Op;						// OPERATION TO BE PERFORMED IN THE UNIT
		public string Fi;						// DESTINATION REGISTER
		public string Fj;						// SOURCE-REGISTER NUMBER
		public string Fk;						// SOURCE-REGISTER NUMBER
		public string Qi;						// FUNCTINAL UNIT PRODUCING SOURCE REGISTERS Fi,Fk
		public string Qk;						// FUNCTINAL UNIT PRODUCING SOURCE REGISTERS Fi,Fk
		public bool Rj;							// FLAG INDICATING WHEN Fj, Fk ARE READY AND NOT YET READ ..
		public bool Rk;							// .. SET TO NO AFTER THE OPERANDS ARE READ
		public Instruction inst;				// INSTRUCTION USING THIS FUNCTIONAL UNIT

		public bool shouldBeFreed = false;		// THIS INDICATES THAT THE FUNCTION UNIT
												// CAN BE FREED OR NOT
		// CONSTRUCTOR
		public FU()
		{
			Flush();	
		}

		// BRING THR STATE OF THE FUNCTIONAL UNIT TO THE DEFAULT STATE
		public void Flush()
		{
			Busy = false ;
			Op = "";
			Fi = "";
			Fj = "";
			Fk = "";
			Qi = "";
			Qk = "";
			Rj = true;
			Rk = true;
			inst = null;
			this.shouldBeFreed = false;
		}
		
		// OVERLOADED []
		public object this [int i]
		{
			// GETTER FUNCTION
			get
			{
				switch(i)
				{
					case 0:
						return (Name) ;						
					case 1:
						return (Busy);
					case 2:
						return (Op);
					case 3:
						return  (Fi);
					case 4:
						return (Fj);
					case 5:
						return (Fk);
					case 6:
						return (Qi);
					case 7:
						return (Qk);
					case 8:
						return (Rj);
					case 9 :
						return (Rk);
				    default :
						throw new IndexOutOfRangeException("Attempt to retreive vector element " + i);
				}
			}	
		
			// SETTER FUNCTION
			set
			{
				switch(i)
				{
					case 0:
						Name = (string)value ;
						break;
					
					case 1:
						Busy = (bool)(value) ;
						break;
					
					case 2:
					
						Op = (string)(value);
						break;

					case 3:
					
						Fi = (string)(value) ;
						break;
					case 4:
					
						Fj = (string)(value) ;
						break;
					case 5:
					
						Fk = (string)(value) ;
						break;
					case 6:
					
						Qi = (string)(value) ;
						break;
					case 7:
					
						Qk = (string)(value);
						break;
					case 8:
					
						Rj = (bool)value ;
						break;
					case 9 :
						Rk = (bool)(value) ;
					    break;
				}
			}
		} 	
	
	}  
}

